﻿using Helper;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Reflection;
using System.Threading;
using System.Windows.Forms;
using ZSMusic.BLLEX;
using ZSMusic.Model;
using ZSMusic.Winform.Properties;

namespace ZSMusic.Winform
{
    static class Program
    {
        /// <summary>
        /// 版本信息
        /// </summary>
        public static VersionInfo Info
        {
            get
            {
                VersionInfo ver = new VersionInfo();
                ver.Title = "ZSMusic";
                ver.IsBeta = true;
                ver.TitleEx = "公测版";
                Assembly assembly = Assembly.LoadFrom("ZSMusic.DAL.dll");
                AssemblyName assemblyName = assembly.GetName();
                ver.Time = new DateTime(2021, 08, 13);
                ver.DALVersion = assemblyName.Version;
                ver.UIVersion = Assembly.GetExecutingAssembly().GetName().Version;
                ver.Description = "首个发布版本\r\n密码:cniy";
                ver.DALUrl = "http://36.99.113.58:40988/ZSMusic.DAL.dll";
                ver.Url = "https://yhcx.lanzoui.com/b0a45jdna";
                return ver;
            }
        }

        public static User CurrentUser { get; set; }

        /// <summary>
        /// 应用程序的主入口点。
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            try
            {
                LoadUser();
                UserSettings.Current = File.Exists("Settings.json") ? JsonConvert.DeserializeObject<UserSettings>(File.ReadAllText("Settings.json")) : UserSettings.Default;
                ThreadPool.QueueUserWorkItem(delegate
                {
                    MusicHelper.FirstRun(null);
                }, null);
                ThreadPool.QueueUserWorkItem(delegate
                {
                    WakeUpServer();
                }, null);
                Console.WriteLine(JsonConvert.SerializeObject(Info));
                Control.CheckForIllegalCrossThreadCalls = false;
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                if (args.Length > 0)
                {
                    switch (args[0])
                    {
                        case "-s":
                            FrmEdit f = new FrmEdit();
                            f.propertyGrid.SelectedObject = UserSettings.Current;
                            f.Text = "配置模式";
                            f.ShowInTaskbar = true;
                            Application.Run(f);
                            File.WriteAllText("Settings.json", JsonConvert.SerializeObject(UserSettings.Current));
                            break;



                        default:
                            break;
                    }
                }
                else
                {
                    Application.Run(new FrmMain());
                }
            }
            catch (Exception ex)
            {
                if (System.Diagnostics.Debugger.IsAttached)
                { throw ex; }
                else
                {
                    Application.Run(new FrmEx(ex));
                }
            }
            finally { SaveUser(); }
        }

        public static void LoadUser()
        {
            CurrentUser = File.Exists("User.json") ? JsonConvert.DeserializeObject<User>(File.ReadAllText("User.json")) : new User();
        }

        public static void SaveUser()
        {
            File.WriteAllText("User.json", JsonConvert.SerializeObject(CurrentUser));
        }

        public static void WakeUpServer()
        {
            try
            {
                HttpHelper.Get(UserSettings.Current.服务器地址);
            }
            catch (Exception)
            { }
        }
    }
}